program AstroGK
  use mp, only: init_mp, finish_mp, proc0, iproc, nproc, broadcast, init_jobs
  use mp, only: scope, allprocs, subprocs, send, receive, barrier, job
  use file_utils, only: init_file_utils, finish_file_utils, run_name, list_name
  use fields, only: init_fields
  use agk_diagnostics, only: init_agk_diagnostics, finish_agk_diagnostics
  use agk_diagnostics, only: nsave
  use run_parameters, only: nstep
  use run_parameters, only: use_Phi, use_Apar, use_Bpar
  use fields, only: advance
  use dist_fn_arrays, only: gnew
  use agk_save, only: agk_save_for_restart
  use agk_diagnostics, only: loop_diagnostics
  use agk_reinit, only: reset_time_step, check_time_step
  use agk_reinit, only: time_message, time_nc, time_reinit
  use agk_time, only: write_dt, init_tstart
  use agk_time, only: time, dtime
  use init_g, only: tstart

  implicit none
!  include 'pat_apif.h'
  real :: time_init = 0., time_advance = 0., time_finish = 0., time_total
  integer :: istep, istep_end, unit, istatus
  logical :: exit, reset, list
  character (500), target :: cbuff


! initialize message passing 
  call init_mp

!  call PAT_tracing_state(PAT_STATE_OFF)

! report # of processors being used
  if (proc0) then
     if (nproc == 1) then
        write(*,*) 'Running on ',nproc,' processor'
     else
        write(*,*) 'Running on ',nproc,' processors'
     end if
     write (*,*) 
! figure out run name or get list of jobs
     call init_file_utils (list, name="AstroGK")
  end if

  call broadcast (list)

! if given a list of jobs, fork
  if (list) call job_fork

  if (proc0) then
     call time_message(.false., .false., time_init,' Initialization')
     cbuff = trim(run_name)
  end if

  call broadcast (cbuff)
  if (.not. proc0) run_name => cbuff

  call init_fields
  call init_agk_diagnostics (list, nstep)
  call init_tstart (tstart)   ! tstart is in user units 
  if (proc0) call time_message(.false.,.false.,time_init,' Initialization')
  istep_end = nstep

!  call PAT_tracing_state(PAT_STATE_ON)
!  call PAT_region_begin(100,'Main advance loop')

  do istep = 1, nstep

     call advance (istep)
     if (nsave > 0 .and. mod(istep, nsave) == 0) &
          call agk_save_for_restart (gnew, time, dtime, istatus, use_Phi, use_Apar, use_Bpar)

     call loop_diagnostics (istep, exit)
     call check_time_step (istep, reset, exit)
     if (proc0) call time_message(.false.,.true.,time_advance,' Advance time step')
     if (reset) call reset_time_step (istep, exit)

     if (mod(istep,5) == 0) call checkstop(exit)

     if (exit) then
        istep_end = istep
        exit
     end if
  end do
  
!  call PAT_region_end(100)
!  call PAT_flush_buffer()
!  call PAT_tracing_state(PAT_STATE_OFF)

  if (proc0) call write_dt

  call finish_agk_diagnostics (istep_end)
  if (proc0) call finish_file_utils
  if (proc0) then
     call time_message(.false., .false., time_finish,'Finished run')
     time_total=time_init+time_advance+time_nc+time_reinit+time_finish
     PRINT '(/,'' Initialization'',T25,0pf8.2,'' min'',T40,2pf5.1,'' %'',/, &
       &'' Advance steps'',T25,0pf9.3,'' min'',T40,2pf5.1,'' %'',/, &
       &'' Write restart'',T25,0pf9.3,'' min'',T40,2pf5.1,'' %'',/, &
       &'' Re-initialize'',T25,0pf9.3,'' min'',T40,2pf5.1,'' %'',/, &
       &'' Finishing'',T25,0pf9.3,'' min'',T40,2pf5.1,'' %'',/,  &
       &'' total from timer is:'', 0pf10.3,'' min'',/)', &
       time_init/60.,time_init/time_total, &
       time_advance/60.,time_advance/time_total, &
       time_nc/60.,time_nc/time_total, &
       time_reinit/60.,time_reinit/time_total, &
       time_finish/60.,time_finish/time_total,time_total/60.
  ENDIF


  call finish_mp

contains

  subroutine timer (i)
    
    character (len=10) :: zdate, ztime, zzone
    integer, dimension(8) :: ival
    real, dimension (:), allocatable, save :: tsave
    real, save :: told=0., tnew=0., tavg
    integer :: i
    integer :: navg=10, j=0
    logical :: first_time = .true.
    
    if (first_time) then
       allocate (tsave(0:navg-1))
       tsave = 0.
       first_time = .false.
    end if

    call date_and_time (zdate, ztime, zzone, ival)
    tnew = ival(5)*3600.+ival(6)*60.+ival(7)+ival(8)/1000.
    if (i == 1) then
       tsave(mod(j,navg)) = tnew-told
       j=j+1
       if (j>=navg) then
          tavg = sum(tsave)/real(navg)
          if (abs((tnew-told)/tavg-1.) > 2.0) then
             print *, 'Avg time = ',tavg, &
                  & '  Time since last called: ',tnew-told,' seconds'
          end if
       else if (told > 0.) then
          print *, 'Time since last called: ',tnew-told,' seconds'
       end if
    end if
    told = tnew
  end subroutine timer

  subroutine job_fork

    use file_utils
    implicit none
    integer, dimension(:), allocatable :: group0
    integer :: i, njobs

    character (len=500), dimension(:), allocatable :: job_list

    integer :: list_unit, ierr

    if (proc0) then
       call get_unused_unit(list_unit)
       open (unit=list_unit, file=trim(list_name))
       read (list_unit,*) njobs
    end if
    call broadcast (njobs)
    
    if (nproc < njobs) then
       if (proc0) then
          write (*,*) 
          write (*,*) 'Number of jobs = ',njobs,' and number of processors = ',nproc
          write (*,*) 'Number of processors must not be less than the number of jobs'
          write (*,*) 'Stopping'
          write (*,*) 
       end if
       call finish_mp
       stop
    end if

    if (mod(nproc, njobs) /= 0) then
       if (proc0) then
          write (*,*) 
          write (*,*) 'Number of jobs = ',njobs,' and number of processors = ',nproc
          write (*,*) 'Number of jobs must evenly divide the number of processors.'
          write (*,*) 'Stopping'
          write (*,*) 
       end if
       call finish_mp
       stop
    end if

    allocate (job_list(0:njobs-1))

    if (proc0) then
       do i=0,njobs-1
          read (list_unit, fmt="(a)") job_list(i)
       end do
       close (list_unit)
    end if

    do i=0,njobs-1
       call broadcast (job_list(i))
    end do

    allocate (group0(0:njobs-1))

    call init_jobs (njobs, group0, ierr)
    call init_job_name (njobs, group0, job_list)

    if (nproc > 1 .and. proc0) &
         & write(*,*) 'Job ',job,' is called ',trim(run_name),&
         & ' and is running on ',nproc,' processors'
    if (nproc == 1) write(*,*) 'Job ',job,' is called ',trim(run_name),&
         & ' and is running on ',nproc,' processor'

  end subroutine job_fork

  subroutine checkstop(exit)

    use mp, only: proc0, broadcast
    use file_utils, only: get_unused_unit, run_name
    logical, intent (in out) :: exit
    integer :: unit

! If .stop file has appeared, set exit flag
    if (proc0) then
       call get_unused_unit (unit)
       open (unit=unit, file=trim(run_name)//".stop", status="old", err=100)
       exit = .true.
       close (unit=unit)
100    continue
    end if

    call broadcast (exit)

  end subroutine checkstop

end program AstroGK
