module agk_save

  implicit none

  public :: agk_restore, agk_save_for_restart
  public :: init_save, init_dt, init_tstart, init_ant_amp

  interface agk_restore
     module procedure agk_restore_many, agk_restore_one
  end interface
  
  private
  character(300), save :: restart_file

contains

  subroutine agk_save_for_restart (g, t0, delt0, istatus, use_Phi, use_Apar, use_Bpar, exit_in)

    use theta_grid, only: ntgrid
! Must include g_layout_type here to avoid obscure bomb while compiling
! agk_diagnostics.f90 (which uses this module) with the Compaq F90 compiler:
    use agk_layouts, only: g_lo, g_layout_type
    implicit none

    complex, dimension (-ntgrid:,:,g_lo%llim_proc:), intent (in) :: g
    real, intent (in) :: t0, delt0
    integer, intent (out) :: istatus
    logical, intent (in) :: use_Phi, use_Apar, use_Bpar
    logical, intent (in), optional :: exit_in

  end subroutine agk_save_for_restart


  subroutine agk_restore_many (g, scale, istatus, use_Phi, use_Apar, use_Bpar, many)

    use theta_grid, only: ntgrid
    use agk_layouts, only: g_lo
    implicit none

    complex, dimension (-ntgrid:,:,g_lo%llim_proc:), intent (out) :: g
    real, intent (in) :: scale
    integer, intent (out) :: istatus
    logical, intent (in) :: use_Phi, use_Apar, use_Bpar
    logical, intent (in) :: many

  end subroutine agk_restore_many

  subroutine agk_restore_one (g, scale, istatus, use_Phi, use_Apar, use_Bpar)
    use theta_grid, only: ntgrid
    use agk_layouts, only: g_lo

    implicit none
    complex, dimension (-ntgrid:,:,g_lo%llim_proc:), intent (out) :: g
    real, intent (in) :: scale
    integer, intent (out) :: istatus
    logical, intent (in) :: use_Phi, use_Apar, use_Bpar

  end subroutine agk_restore_one

  subroutine init_save (file)
    character(300), intent (in) :: file
    
    restart_file = file

  end subroutine init_save

  subroutine init_dt (delt0, istatus)

    implicit none
    real, intent (in out) :: delt0
    integer, intent (out) :: istatus

  end subroutine init_dt

  subroutine init_ant_amp (a_ant, b_ant, nk_stir, istatus)

    use mp, only: proc0
    use constants
    implicit none
    complex, dimension(:), intent (in out) :: a_ant, b_ant
    integer, intent (in) :: nk_stir
    integer, intent (out) :: istatus

    if (proc0) istatus = 2

  end subroutine init_ant_amp

  subroutine init_tstart (tstart, istatus)

    implicit none
    real, intent (in out) :: tstart
    integer, intent (out) :: istatus
    
  end subroutine init_tstart

end module agk_save
