module agk_time

  implicit none

  private

  real :: dtime
  real :: tstart
  real :: dt_cfl = -1.

  real :: dt_max, dt_min

! GGH points out that this initialization is not necessary (we think)
  real :: time = 0.

  public :: dtime, time, dt_max, dt_min, dt_cfl
  public :: save_dt_min, save_dt, save_dt_cfl, write_dt
  public :: init_tstart, init_delt, update_time
  
contains

  subroutine init_tstart (tstart)

    real, intent (in) :: tstart

    time = tstart

  end subroutine init_tstart

  subroutine init_delt (delt)
    real, intent (in) :: delt

    dtime = delt

  end subroutine init_delt

  subroutine update_time

    time = time + dtime

  end subroutine update_time

  subroutine save_dt_cfl (delt_cfl)

    real, intent (in) :: delt_cfl

    dt_cfl = delt_cfl

  end subroutine save_dt_cfl

  subroutine save_dt_min (dt_min_in)

    real, intent (in) :: dt_min_in

    dt_min = dt_min_in

  end subroutine save_dt_min

  subroutine save_dt(delt)
    
    real, intent (in) :: delt

    dtime = delt
    
  end subroutine save_dt

  subroutine write_dt

    if (dt_cfl > 0. .and. dt_cfl < 1.e7) write(*,*) dt_cfl,' : ',dtime
       
  end subroutine write_dt

end module agk_time
