module run_parameters
  implicit none

  public :: init_run_parameters

  public :: beta, zeff, tite
  public :: fphi, fapar, fbpar
  public :: use_Phi, use_Apar, use_Bpar
  public :: nstep, delt_max
  public :: eqzip, secondary, tertiary

  private

  real :: beta, zeff, tite
  real :: fphi, fapar, fbpar, faperp
  real :: delt, delt_max
  integer :: nstep
  logical :: use_Phi, use_Apar, use_Bpar
  logical :: eqzip, secondary, tertiary

  integer :: delt_option_switch
  integer, parameter :: delt_option_hand = 1, delt_option_auto = 2

contains

  subroutine init_run_parameters
    use kgrids, only: init_kgrids, naky
    use agk_time, only: init_delt
    
    implicit none
    logical, save :: initialized = .false.

    if (initialized) return
    initialized = .true.

    call read_parameters

    call init_kgrids
    call init_delt (delt)

  end subroutine init_run_parameters

  subroutine read_parameters
    use file_utils, only: input_unit, error_unit, input_unit_exist
    use mp, only: proc0, broadcast
    use agk_save, only: init_dt
    use text_options
    implicit none
    type (text_option), dimension (3), parameter :: deltopts = &
         (/ text_option('default', delt_option_hand), &
            text_option('set_by_hand', delt_option_hand), &
            text_option('check_restart', delt_option_auto) /)
    character(20) :: delt_option
    integer :: ierr, istatus, in_file
    real :: delt_saved

    logical :: exist
    namelist /parameters/ beta, zeff, tite
    namelist /knobs/ delt, nstep, eqzip, secondary, tertiary, &
         delt_option, use_Phi, use_Apar, use_Bpar

    if (proc0) then
       use_Phi = .true.    ;   fphi = 0.0
       use_Apar = .true.   ;   fapar = 0.0
       use_Bpar = .true.   ;   fbpar = 0.0

       beta = 0.0
       zeff = 1.0
       tite = 1.0
       eqzip = .false.
       secondary = .true.
       tertiary = .false.
       delt_option = 'default'
       in_file = input_unit_exist("parameters", exist)
       if (exist) read (unit=input_unit("parameters"), nml=parameters)

       in_file = input_unit_exist("knobs", exist)
       if (exist) read (unit=input_unit("knobs"), nml=knobs)

       if (use_Phi) fphi = 1.0
       if (use_Apar) fapar = 1.0
       if (use_Bpar) fbpar = 1.0

       if (eqzip) then
          if (secondary .and. tertiary) then
             ierr = error_unit()
             write (ierr, *) 'Forcing secondary = FALSE'
             write (ierr, *) 'because you have chosen tertiary = TRUE'
             secondary = .false.
          end if
       end if

       ierr = error_unit()
       call get_option_value &
            (delt_option, deltopts, delt_option_switch, ierr, &
            "delt_option in knobs")
    end if

    call broadcast (delt_option_switch)
    call broadcast (delt)
    call broadcast (beta)
    call broadcast (zeff)
    call broadcast (tite)
    call broadcast (use_Phi)
    call broadcast (use_Apar)
    call broadcast (use_Bpar)
    call broadcast (fphi)
    call broadcast (fapar)
    call broadcast (fbpar)
    call broadcast (nstep)
    call broadcast (eqzip)
    call broadcast (secondary)
    call broadcast (tertiary)
    delt_max = delt

    delt_saved = delt
    if (delt_option_switch == delt_option_auto) then
       call init_dt (delt_saved, istatus)
       if (istatus == 0) delt  = delt_saved
    endif

  end subroutine read_parameters

end module run_parameters
