! Calculate pi by integrating sqrt(1-x**2) over [0,1], which gives pi/4.

program calcpi
  implicit none
  
  ! Choose precision for integer and real numbers:
  ! - at least 15 digits
  ! - for reals, a range of at least up to 10^100
  integer, parameter :: ik = selected_int_kind(15)
  integer, parameter :: rk = selected_real_kind(15, 100)
  
  ! Number of integration steps
  integer(ik), parameter :: n = 1000_ik
  
  real(rk)    :: dx             ! step size
  real(rk)    :: pi             ! calculated pi
  integer(ik) :: i              ! loop counter
  real(rk)    :: x, y           ! point on circle
  
  print '("Calculate pi")'
  print '("   using n=",i0)', n
  print '()'
  print '("calculating...")'
  
  ! Define step size
  dx = 1.0_rk / n
  ! Initialise integral
  pi = 0
  ! Integrate
  do i=1,n
     ! Calculate point on circle
     x = i * dx
     y = sqrt(1 - x**2)
     ! Update integral
     pi = pi + y * dx
  end do
  pi = 4 * pi
  
  print '("Calculated pi=",f20.15)', pi
  print '("Accurate   pi=",f20.15)', acos(-1.0_rk)
  print '("Error      e =",f20.15)', pi - acos(-1.0_rk)
end program calcpi
